# This is a test version for setting up CASP1 membrane coordination estimation/statistics

library(Rmisc)
library(tidyverse)
library(agricolae)
library(readxl)

# ******************************************************************
# Laptop
# ******************************************************************

#patch_quant <- read_excel("Patch quantification/patch quantification.xlsx")
patch_quant <- read_excel("Patch quantification/patch quantification_new.xlsx")

colnames(patch_quant) <- c("genotype","sample_id", "cell_id","location", "patch_number","cell_length") # rename columns

patch_quant<- patch_quant %>%
  filter(genotype!="35S-LOTR1")

mydata_inside<- patch_quant %>%
  filter(location == "inside")# %>%
#select(patch_number)

mydata_total <- patch_quant %>%
  group_by(genotype,sample_id, cell_id) %>%
  summarise(patch_total = sum(patch_number),
            cell_length = mean(cell_length))


mydata <- mydata_total
mydata$patch_ratio <- mydata_inside$patch_number/mydata_total$patch_total




# ******************************************************************
# quick check if cell length depends on genotype
# ******************************************************************
plot.cell_length <- ggplot(mydata, aes(x=genotype, y=cell_length))+
  geom_boxplot(fill="grey")+
  geom_jitter(shape=16, size=3, position=position_jitter(0.2))+
  annotate(geom = "text", x="C1-LOTR1", y=145, label= "a", size=6)+
  annotate(geom = "text", x="lotr1-10", y=145, label= "a", size=6 )+
  scale_x_discrete(labels=c(
    expression(paste("C1::sec-mScaI-LOTR1 (", italic("lotr1-10") ,")")),
    expression(italic("lotr1-10"))
  ))+
  labs( x="Genotype", y= "Cell length [m]"#,
        #title="Patch quantification"
  )+
  theme_classic()
plot.cell_length


# ******************************************************************
# patch distribution only lotr1
# ******************************************************************
pdf("Patch distribution.pdf", useDingbats=FALSE, width = 3, height = 5)


plot.ENdistr_lotr1 <- ggplot(mydata, aes(x=genotype, y=(patch_ratio)))+
  #ylim(0,1.25)+
  geom_boxplot(outlier.colour="red", outlier.shape=17, outlier.size=3, fill="grey")+
  geom_jitter(shape=16, size=3, position=position_jitter(0.2))+
  annotate(geom = "text", x="C1-LOTR1", y=1.2, label= "a", size=6)+
  annotate(geom = "text", x="lotr1-10", y=1.2, label= "a", size=6 )+
  scale_x_discrete(limits=c("lotr1-10"))+
  scale_y_continuous(breaks=seq(0,1,0.25),limits = c(0,1.25))+
  labs( x="Genotype", y= "Ectopic CASP1-GFP deposits [EN-PE/total]"#,
        #title="Patch quantification"
  )+
  theme_classic()
plot.ENdistr_lotr1

dev.off()




